using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class CONTACT_LOGDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public CONTACT_LOGDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public CONTACT_LOG GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 CONTACT_LOG_ID)
		{
			CONTACT_LOG objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_CONTACT_LOG_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, CONTACT_LOG_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<CONTACT_LOG> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<CONTACT_LOG> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_CONTACT_LOG_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, CONTACT_LOG objSave)
		{
			Int32? objReturn = objSave.CONTACT_LOG_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_CONTACT_LOG_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.CONTACT_ADDR1, objSave.CONTACT_ADDR2, objSave.CONTACT_ADDR3, objSave.CONTACT_CITY, objSave.CONTACT_COUNTRY, objSave.CONTACT_DATE, objSave.CONTACT_EMAIL, objSave.CONTACT_FIRST_NAME, objSave.CONTACT_LAST_NAME, ref objReturn, objSave.CONTACT_MESSAGE_TEXT, objSave.CONTACT_METHOD_TEXT, objSave.CONTACT_PHONE, objSave.CONTACT_POSTAL, objSave.CONTACT_REASON_TEXT, objSave.CONTACT_STATE, objSave.CONTACT_ZIPPLUS4, DateTime.Now, objSave.CREATEDBY, objSave.DATE_REMIND_ME_ON, objSave.FOLLOWUP_COMPL_DATE, objSave.FOLLOWUP_REASON_TEXT, objSave.FOLLOWUP_REQUIRED_DATE, objSave.FOLLOWUP_REQUIRED_FLAG, objSave.INPATIENT_EVAL_DATE, objSave.INPATIENT_EVAL_RECOM_FLAG, objSave.REFERRAL_ID, objSave.TELEMEDICINE_PATIENT_FLAG, objSave.TELEMEDICINE_PROVIDER_FLAG, DateTime.Now, objSave.UPDATEDBY);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 CONTACT_LOG_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_CONTACT_LOG_delete(CURRENT_USER, CURRENT_REGISTRY_ID, CONTACT_LOG_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
        }
        public CONTACT_LOG_PATIENT GetItemByReferralId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            CONTACT_LOG_PATIENT objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_PATIENT_getitemByReferralId(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }
        public IEnumerable<ReferralContactLog> GetContactLogs(
           string CURRENT_USER,
           int CURRENT_REGISTRY_ID,
           string PATIENT_LAST_NAME,
           string SORT_COLUMN,
           int? START_ROW,
           int? MAX_ROWS)
        {
            List<ReferralContactLog> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_CONTACTLOGS_getItems(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            PATIENT_LAST_NAME,
                            SORT_COLUMN,
                            START_ROW,
                            MAX_ROWS)
                        .ToList();

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn;
        }

        public int GetContactLogsCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_LAST_NAME)
        {
            int? objReturn = 0;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext
                        .usp_CONTACTLOGS_getItemCounts(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            PATIENT_LAST_NAME,
                            ref objReturn);

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }

            return objReturn.HasValue ? objReturn.Value : 0;
        }

        #endregion
    }
}
